%This Model has been adapted from the MATLAB code presented in Hoppensteadt
%and Peskin "Modling and Simulation in Medicine and the Life Sciences

%Time parameters
T = 0.0125;                      %Duration of heartbeat: min
Ts = 0.0050;                     %Duration of systole: min
Stroke_volume = 70e-3;           %Volume ejected by 1 heart beat: L
Tmax = 0.0020;                   %Time at which flow is max: min
Qmax= Stroke_volume/(0.5*Ts);    %Max flow through aortic valve: L/min
dt = .01*T;                      %This choice implies 100 timesteps per cardiac cycle

%Compliance and resistiance values for arteries
Csa = .00175;                      %Systemic arterial compliance: L/mmHg
Rs = 17.86;                      %Systemic resistance: mmHg/(L/min)
